//
//  NSBundle+RMAdditions.h
//  RMAppKit
//
//  Created by Keith Duncan on 14/07/2011.
//  Copyright 2011 Realmac Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@interface NSBundle (RMAppKitAdditions)

/*!
	\brief
	An NSDictionary object mapping style directory name keys, to system version strings.
 */
extern NSString *const RMMinimumSystemVersionByStyleKey; /* @"RMMinimumSystemVersionByStyle" */

/*!
	\brief
	Preferred API, as a complement to `URLForImageResource:`, though doesn't currently return images with multiple reps.
	
	\details
	In the image is found in an imageProj directory, attributes from the imageProj Info.plist are applied to the NSImage.
 */
- (NSImage *)imageForStyleImageResource:(NSString *)name;

@end
